

************************************************************
************************************************************
***           Marriage and Happiness                     ***
***    Further Linear Panel Models (chap. VII)           ***
***		    Josef Brderl, Volker Ludwig                 *** 	   
***		             March 2015                          *** 	   
************************************************************
************************************************************

/* Data: SOEP 1984-2009 v26

We start with file "Happiness2.dta"
This file was prepared with "Happiness 2 DataPrep.do"

The lecture-package includes an anonymized version of this file:
A 50% random sample (on the person level), with artificial IDs,
and with a normally distributed random error (m=0, sd=10) added to
household income. Therefore, results are very similar, but not 
identical to the ones reported in the lecture. */


*************************************
** Preliminaries    *****************
*************************************
clear 
set seed 17838276                          //Set seed to replicate

* Load data
cd  "K:\Vorlesung PDA\Stata Beispiele\"    //Adapt this path!
use "Happiness2.dta", clear

***** Declare data to be panel data *****
xtset id year

*********   New variables needed below       ******************
bysort id: egen treat = max(marry)   //indicator for treatment group 
bysort id (year): gen pynr    = _n   //person-year ID (within person)
bysort id:        gen pycount = _N   //# of person-years (within person)
gen cohort = year - age              // birth cohort
sum age
gen agec = age - r(mean)             // age centered

* Decompose each time-varying covariate into two components
foreach var of varlist marry age loghhinc {
   bysort id: egen  m`var' = mean(`var')     //between component
   gen              d`var' = `var' - m`var'  //within component
}


*****************************************************************
*****   Alternative Within Estimators                       *****
*****************************************************************

*********   Person-specific regressions *******************************
preserve
keep if pycount == 26   //only panels with 26 observations (the longest panels)
xtreg happy age, fe     //benchmark FE model

statsby cons=_b[_cons] slope=_b[age], by(id) saving(sepreg, replace) nodots: ///
        regr happy age

*  Taking the (unweighted) means of the coefficients
merge m:1 id using sepreg, nogen
summ slope cons if pynr==1             //perfectly identical

* Plotting the individual regression lines (spaghetti plot)
generate pred = cons + slope*age
sort cohort id age  //the older ones first (otherwise different lines would be connected!)
line pred age, connect(ascending) lcolor(blue)             ///  
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)90)     ///
        xtitle("Age", size(large) margin(0 0 0 2))         ///
        ytitle("Predicted Happiness", size(large))
restore
************************************************************************
					
************  LSDV Model (with areg) *****************************
xtreg   happy marry age loghhinc, fe vce(cluster id)  //benchmark FE model
est store FE
areg   happy marry age loghhinc, absorb(id)  vce(cluster id)  
est store AREG
estimates table FE AREG, keep(marry age loghhinc) b se b(%9.4f)
******************************************************************


		 
***************************************************************
**** FE - Individual Slopes Model (FEIS)                  ****
***************************************************************

******* Explorative tests of the parallel trends assumption ************

* FE             linear growth curve interacted with treatment (nested effects)
xtreg happy marry i.treat#c.age loghhinc, fe vce(cluster id)
margins treat, at(age=(0(5)90)) noatlegend  //is not identified, but nice graph
marginsplot, recast(line) noci          	

* FE             linear growth curve interacted with treatment (standard spec.)
xtreg happy marry i.treat##c.age loghhinc, fe vce(cluster id)

* Distributed FE linear growth curve interacted with treatment
gen             h1 = year - yrsmarried    //current year or marriage year
bysort id: egen h2 = max(h1) if treat==1  //marriage year
gen     h3 = year - h2 if treat==1        //event centered time scale for treated
recode  h3  min/-7=-7   15/max=15         //group on the borders
recode  h3  .=-7                          //not-treated are in ref group
gen     ym = h3+7                         //bring all to positive values
xtreg happy i.ym i.treat##c.age loghhinc, fe vce(cluster id)


******** Model estimates **********************************************
* For this you need "xtfeis.ado". Available from Volker Ludwig

* FE benchmark
xtreg  happy marry loghhinc age if pycount > 2, fe vce(cluster id)
est store FE

* FEIS1: heterogenous growth curves
xtfeis happy marry  loghhinc   , slope(age) cluster(id)
est store FEIS1

* FEIS2: heterogeneous income effects
xtfeis happy marry  age   , slope(loghhinc) cluster(id)
est store FEIS2

* FEIS3: all controls heterogeneous
xtfeis happy marry    , slope(loghhinc age) cluster(id)
est store FEIS3

estimates table FE FEIS1 FEIS2 FEIS3, b(%9.4f) t(%9.4f) stats(N)  ///
         keep(marry age loghhinc) 



************************************************************
***   Mixed-Effects Models      ****************************
************************************************************

xtreg     happy loghhinc age              , re vce(cluster id)
est store RE
mixed     happy loghhinc age ||id:        , vce(cluster id)
est store RI
mixed     happy loghhinc age ||id: age    , vce(cluster id) cov(unstructured) stddev
est store RS
xtreg     happy loghhinc age              , fe vce(cluster id)
est store FE
xtfeis    happy loghhinc   , slope(age)   cluster(id)
est store FEIS

estimates table RE RI RS FE FEIS, b(%9.4f) t(%9.4f) stats(N) equations(1)  ///
         keep(loghhinc age) 


************************************************************
***   Group Specific RS Growth Curves          *************
************************************************************

* To save computational time: (takes about 20 minutes)
* - without panel-robust S.E.s
* - only linear age term is a random coefficient
mixed happy marry loghhinc i.woman i.woman#(c.agec##c.agec##c.agec) ib(last).cohort ///
      i(1987/1989 1992/2009)bn.year ||id: agec, cov(unstructured) stddev

margins woman, at(agec=(-10(5)60)) noatlegend          //profile plot
marginsplot, recast(line) noci          	                    ///
        ylabel(0(1)8, grid angle(0)) xlabel(-9.3 "20" .7 "30" 10.7 "40"  ///
		20.7 "50" 30.7 "60" 40.7 "70" 50.7 "80" 60.7 "90")      ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(7) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title("profile plot") 
graph save plotgc1, replace
margins , at(agec=(-10(5)60)) dydx(woman) noatlegend  //conditional effect plot
marginsplot, recast(line) recastci(rline) yline(0)               ///
        ylabel(-1(0.25)1.5, grid angle(0) format(%3.2f))         ///
		xlabel(-9.3 "20" .7 "30" 10.7 "40"                       ///
		20.7 "50" 30.7 "60" 40.7 "70" 50.7 "80" 60.7 "90")       ///
        xtitle("Age", size(large) margin(0 0 0 2))               ///
        ytitle("AME of 'woman' on happiness", size(large))       ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))     ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(blue))     ///  
		title("conditional effect plot")
graph save plotgc2, replace

graph combine "plotgc1" "plotgc2", xsize(7)



*********************************************************
*** Hybrid models                          **************
*********************************************************

xtreg happy marry age loghhinc woman,  be                  //between regression
est store BE0
xtreg happy marry age loghhinc woman,  fe vce(cluster id)  //FE regression
est store FE0

* Hybrid: Run a RE-model with both components
xtreg happy mmarry dmarry mage dage mloghhinc dloghhinc woman, re vce(cluster id)
est store HYBR1

estimates table BE0 FE0 HYBR1, star b(%9.4f)                              ///
         keep(marry mmarry dmarry age mage dage loghhinc mloghhinc dloghhinc woman) 

* Test whether between and within estimates do not differ
test (mmarry=dmarry) (mage=dage) (mloghhinc=dloghhinc)

* Hybrid (Variants)
* Mundlak model
xtreg happy mmarry marry mage age mloghhinc loghhinc woman, re vce(cluster id)
est store HYBR2
* POLS estimation
reg happy mmarry marry mage age mloghhinc loghhinc woman, vce(cluster id)
est store HYBR3
estimates table BE0 FE0 HYBR2 HYBR3, star b(%9.4f)                              ///
         keep(marry mmarry age mage loghhinc mloghhinc woman) 

* Hybrid RS
mixed happy mmarry dmarry mage dage mloghhinc dloghhinc woman ||id: dmarry,  cov(unstructured) stddev
est store RSHYBR
		 
* Mundlak RS
mixed happy mmarry marry mage age mloghhinc loghhinc woman ||id: marry,  cov(unstructured) stddev
est store RSMUNDL

estimates table FE0 RSHYBR RSMUNDL, star b(%9.4f) stats(N) equations(1)       ///
         keep(marry dmarry age dage loghhinc dloghhinc woman) 


*********************************************************
***    LDV models                          **************
*********************************************************

*************** FE
xtreg   happy marry age loghhinc woman, fe vce(cluster id)
est store FE

*************** POLS-LDV
reg   happy L.happy marry age loghhinc woman i.cohort, vce(cluster id)
est store POLSLDV

*************** FE-LDV
xtreg   happy L.happy marry age loghhinc woman, fe vce(cluster id)
est store FELDV

*************** AB-LDV
xtabond   happy marry age loghhinc woman, lags(1) vce(robust)
est store ABLDV

estimates table FE POLSLDV FELDV ABLDV, b(%7.2f) star stfmt(%6.0f) stats(N N_clust) ///
                keep(L.happy marry age loghhinc woman)

